<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Components\SingleDropzoneComponent;
use App\Http\Controllers\Components\JobReviewCostCalComponent;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Collection;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests\Admin\Quotations\QuotationItemsRequest;
use App\Models\Jewellery;
use App\Models\Consignment;
use App\Models\Admin;
use App\Models\User;
use App\Models\Job;
use Validator;
use File;
use Log;
use DB;


class AjaxController extends Controller
{
    function __construct(SingleDropzoneComponent $singleDropzone, JobReviewCostCalComponent $JobReviewCostCalComponent)
    {
        $this->singleDropzone = $singleDropzone;
        $this->JobReviewCostCalComponent = $JobReviewCostCalComponent;
    }

    const UNIT_ARRAY = [ 'Ring'=>'cm', 'Earing'=>'cm', 'Bracelet'=>'inch', 'Necklace'=>'inch', 'Pendant'=>'cm', 'Brooch'=>'cm' ];

    public function getSizesByCategoryId(Request $request)
    {
        try{
            $validator = Validator::make($request->all(), [
                'category_id' => "required|integer"
            ]);

            if ($validator->fails()) {
                return response()->json(['errors'=>$validator->errors()]);
            }

            $records = Size::with('category')->where(['category_id'=>$request->category_id, 'status'=>'Active'])->get(Size::DEFAULT_SELECT)->makeHidden(Size::DEFAULT_HIDE);

            $collection = $records->map(function ($item, $key) {
                return ['id'=>$item['id'], 'size_with_unit'=>in_array($item->category->name,array_keys(self::UNIT_ARRAY))? $item->name.' '.self::UNIT_ARRAY[$item->category->name] : $item->name];
            })->toArray();

            return response()->json(['res'=>$collection]);
        } catch(\Exception $err){
            Log::error('Error in getSizesByCategoryId on AjaxController :'. $err->getMessage());
            return back()->with('error', $err->getMessage());
        }
    }

    public function phoneAutocompleteSearch(Request $request)
    {
        $data = User::select('phone')
            ->where('phone', 'LIKE', '%' . $request->query('customer_phone') . '%')
            ->get();
            return response()->json($data);
    }

    public function getUserByPhone(Request $request)
    {
        $phone= explode(" ",$request->phone);
        if(isset($phone[1])){
            $search=$phone[1];
        }else{
            $search=$phone[0];
        }

        $data = User::select("image","fullname","email")->where('phone', 'LIKE', '%' . $search . '%')
            ->first();
        return response()->json($data);
    }

    public function singleDropzoneStore(Request $request)
    {
        try {
            $imageName =  $this->singleDropzone->ajaxStoreTmpImage($request);
            if (!empty($imageName)) {
                return response()->json([
                    'status' => 1,
                    'file' => $imageName,
                    'message' => "Image Upoload Successfully!"
                ]);
            } else {
                return response()->json([
                    'status' => 0,
                    'message' => "Image not Upoload!"
                ]);
            }
        } catch (\Exception $err) {
            Log::error('Error in dropzoneStore on AjaxController :' . $err->getMessage());
            return back()->with('error', $err->getMessage());
        }
    }

    public function getJewelleryByItemCode(Request $request,$module)
    {
        try {
            $res = [];
            $validator = Validator::make($request->all(), [
                'item_code' => 'required',
            ]);

            if ($validator->fails()) {
                $res['status'] = 0;
                $res['errors'] = $validator->errors();
            }
            if ($validator->passes()) {
                $buttonIndex = $request->index;
                $jewellery = Jewellery::getJewelleryByItemCode($request->item_code);
                if ($jewellery) {
                    $html = view("admin.$module.button_render", compact('buttonIndex'))->render();
                    $res['status'] = 1;
                    $res['message'] = 'Fetch jewellery by Item Code successfully!';
                    $res['data'] = $jewellery;
                    $res['render_button'] = $html;
                } else {
                    $res['status'] = 0;
                    $res['message'] = 'Item not found!';
                }
            }
        } catch (\Exception $err) {
            Log::error('Error in getJewelleryByItemCode on AjaxController :' . $err->getMessage());
            $res['status'] = 0;
            $res['message'] = $err->getMessage();
        }
        return response()->json($res);
    }

    public function getJobByItemCode(Request $request,$module)
    {
        try {
            $res = [];
            $validator = \Illuminate\Support\Facades\Validator::make($request->all(), [
                'item_code' => 'required',
            ]);

            if ($validator->fails()) {
                $res['status'] = 0;
                $res['errors'] = $validator->errors();
            }
            if ($validator->passes()) {
                $buttonIndex = $request->index;
                $job = Job::getJobByItemCode($request->item_code);
                if ($job) {
                    $html = view("admin.$module.button_render", compact('buttonIndex'))->render();
                    $res['status'] = 1;
                    $res['message'] = 'Fetch job by Item Code successfully!';
                    $res['data'] = $job;
                    $res['render_button'] = $html;
                } else {
                    $res['status'] = 0;
                    $res['message'] = 'Item not found!';
                }
            }
        } catch (\Exception $err) {
            Log::error('Error in getJobByItemCode on AjaxController :' . $err->getMessage());
            $res['status'] = 0;
            $res['message'] = $err->getMessage();
        }
        return response()->json($res);
    }

    public function bespokeReairData(QuotationItemsRequest $request)
    {
        try {
            $validated = $request->validated();
            $buttonIndex = $request->index;
            $review_cost = $this->JobReviewCostCalComponent->calculateCost($validated);
            // dd($request->toArray());
            $data = $request->except(['index']);
            if ($review_cost['status'] == 1) {
                $html = view('admin.quotations.button_render', compact('buttonIndex'))->render();
                $res['status'] = 1;
                $res['message'] = 'Item added successfully!';
                $res['data'] = $data;
                $res['subtotal'] = $review_cost['data']['sub_total'];
                $res['render_button'] = $html;
            } else {
                $res['status'] = 0;
                $res['message'] = 'Item not added!';
            }
        } catch (\Exception $err) {
            Log::error('Error in bespokeReairData on QuotationsController :' . $err->getMessage());
            $res['status'] = 0;
            $res['message'] = $err->getMessage();
        }
        return response()->json($res);
    }

    public function getUserPhoneList(Request $request)
    {
        $phone= explode(" ",$request->q);
        if(isset($phone[1])){
            $search=$phone[1];
        }else{
            $search=$phone[0];
        }

        $all_data = User::selectRaw("email,fullname, concat(COALESCE(`country_code`,''),' ', phone) as phone")->where('phone', 'LIKE', $search . '%')->where('status',User::ACTIVE)->distinct()->get()->take(25);
        
        $data = [];
        foreach($all_data as $key => $value){
            $data[$key]['value']=$value->phone;
            $data[$key]['lable']=$value->phone;
            $data[$key]['fullname']=$value->fullname;
            $data[$key]['email']=$value->email;
        } 
        return response()->json($data);
    }

    public function getJewelleryItemCodeList(Request $request)
    {
        $search  = $request->itemcode;
        // $all_data = [];
        $data = [];

        $jewellery_data = Jewellery::with(['review_cost'])->where('item_code', 'LIKE', $search . '%')->where('status',Jewellery::ACTIVE)->whereHas('review_cost', function($q)
        {
          $q->where('total','!=', 0);
        })->get()->take(25);

        $consignment_data = Consignment::with(['consignment_item','consignment_review_cost'])->where('consignment_no', 'LIKE', $search . '%')->get()->take(25);
       
        if(!empty($jewellery_data)){
            foreach($jewellery_data as $key => $value){ 
                $data[$key]['value']=$value['item_code'];
                $data[$key]['lable']=$value['item_code'];
                $data[$key]['weight']= 1;
                $data[$key]['unit_price']= (float)$value['review_cost']['sub_total'];
                $data[$key]['price']= (float)1 * $value['review_cost']['sub_total'];
            } 
        }
        if(!empty($consignment_data)){
            foreach($consignment_data as $key => $value){ 
                $data[$key]['value']=$value['consignment_no'];
                $data[$key]['lable']=$value['consignment_no'];
                $data[$key]['weight']=(float)$value['consignment_item']['weight'];
                $data[$key]['unit_price']= (float)$value['consignment_item']['unit_price'];
                $data[$key]['price']= (float)$value['consignment_item']['total_price'];
            } 
        }
        return response()->json($data);
    }

}