<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Requests\Admin\ProfileUpdateRequest;
use App\Http\Requests\Admin\ChangePasswordRequest;
use App\Models\Admin;
use Validator;
use Auth;
use Hash;
use Log;

class AdminController extends Controller
{
	public function __construct()
    {
    // $this->middleware(['auth','is_admin']);
    }

    public function showProfileForm()
    {
        try{
            $admin = Admin::findOrFail(Auth::guard('admin')->user()->id);
            return view('admin.profile.index',compact('admin'));
        } catch(\Exception $err){
            Log::error('Error in showProfileForm on AdminController :'. $err->getMessage());
            return back()->with('error', $err->getMessage());
        }
    }

    public function updateProfile(ProfileUpdateRequest $request)
    {
        try{
            $validated = $request->validated();

            $admin = Admin::findOrFail(Auth::guard('admin')->user()->id);
            $admin->fullname = $validated['fullname'];
            $admin->email = $validated['email'];
            $admin->username = $validated['username'];
            $phoneNo_with_code = explode(' ', $validated['phone']);
            $country_code = (count($phoneNo_with_code) > 1) ? $phoneNo_with_code[0] : null;
            $phone_no = (count($phoneNo_with_code) > 1) ? $phoneNo_with_code[1] : $phoneNo_with_code[0];
            $admin->country_code = $country_code;
            $admin->phone = $phone_no;
            $admin->dob = date('Y-m-d', strtotime($validated['dob']));
            $admin->gender = $validated['gender'];
            $admin->save();

            return redirect()->route('admin.showProfileForm')
            ->with(["success"=>"Your profile has been updated successfully!"]);
            } catch(\Exception $err){
            Log::error('Error in updateProfile on AdminController :'. $err->getMessage());
            return back()->with('error', $err->getMessage());
            }
    }


    public function updateProfilePic(Request $request)
    {
        try{
            $admin = Admin::findOrFail(Auth::guard('admin')->user()->id);
            $oldImage = $admin->image;

            if (!file_exists(public_path(Admin::IMAGE_PATH))) {
                mkdir( public_path(Admin::IMAGE_PATH) , 0777, true);
            }
            $image = $request->image;
            list($type, $image) = explode(';', $image);
            list(, $image) = explode(',', $image);
            $image = base64_decode($image);
            $image_name= time().'.png';

            $admin->image = $image_name;
            $path = public_path(Admin::IMAGE_PATH.$image_name);
            @file_put_contents($path, $image);

            $admin->save();
            if($oldImage && file_exists(public_path(Admin::IMAGE_PATH.$oldImage))){
                @unlink(public_path(Admin::IMAGE_PATH.$oldImage));
            }

            return response()->json(['status' => 1, 'message' => asset('public/'.Admin::IMAGE_PATH.$image_name)]);
        } catch(\Exception $err){
            Log::error('Error in updateProfilePic on AdminController :'. $err->getMessage());
            return back()->with('error', $err->getMessage());
        }
    }

    public function showPasswordForm()
    {
        try{
            return view('admin.profile.change_password');
        } catch(\Exception $err){
            Log::error('Error in showPasswordForm on AdminController :'. $err->getMessage());
            return back()->with('error', $err->getMessage());
        }
    }

    public function updatePassword(ChangePasswordRequest $request)
    {
        try{
            $password = bcrypt($request->password);
            $admin = Admin::findOrFail(Auth::guard('admin')->user()->id);
            $admin->update(['password'=>$password]);

    		return redirect()->route('admin.showPasswordForm')
    			->with(["success"=>"Password changed successfully."]);
        } catch(\Exception $err){
            Log::error('Error in updatePassword on AdminController :'. $err->getMessage());
            return back()->with('error', $err->getMessage());
        }
    }
}
