<?php
use Illuminate\Support\Facades\DB;
use App\Models\Jewellery;
use App\Models\Quotation;
use App\Models\Invoice;
use App\Models\Job;
use App\Models\Setting;
use App\Models\RoleHasPermission;


//------------------------------------------------------------------
    if (! function_exists('pr')) {
        function pr($data=array()){
            echo "<pre>" ;
            print_r($data);
            echo "</pre>";
        }
    }

    function getDefaultImage()
    {
        return asset('public/img/default-placeholder.jpg');
    }
//-----------------------------------------------------------------------

    function getBrownImageForCategory($categoryName)
    {
        $brownImage = '';
        if(File::exists(public_path('img/brown_'.strtolower($categoryName).'.png'))){
            $brownImage = asset('public/img/brown_'.strtolower($categoryName).'.png');
        }
        return $brownImage;
    }

//------------------------------------------------------------------------

// function getPermissionsArrayByRoleId($role_id)
// {
//     $permissionsArr = RoleHasPermission::with(['permission:id,name'])->where('role_id', $role_id)->get();
    
//     $data = $permissionsArr->mapToGroups(function ($item, $key) {
//         return [$item['role_id'] => $item['permission']['name']];
//     })->toarray();
//     return $data[$role_id];
// }

//-----------------------------------------------------------------------

    // Claculate GST
    function calculateGST($amount)
    {
        $amount = (float) $amount;
        $priceSettings = Setting::price_settings();
        $gstPercent = (float) $priceSettings['gst_percent'];
        return $gstAmount = (float) ((float) ($amount * $gstPercent) / 100);
    }

//-----------------------------------------------------------------------

    function validateDate($date, $format = 'Y-m-d')
    {
        $d = DateTime::createFromFormat($format, $date);
        // The Y ( 4 digits year ) returns TRUE for any integer with any number of digits so changing the 
        // comparison from == to === fixes the issue.
        return $d && $d->format($format) === $date;
    }

    function dateDifferenceInDaysWithSign($date1, $date2){
        $date1=date_create($date1);
        $date2=date_create($date2);  
        $dateDiff = date_diff($date1, $date2);
        $diffFormat = $dateDiff->format("%R%a"); // in days
        return $diffFormat;
    }

    function dateDifferenceInDaysWithoutSign($date1, $date2){
        $date1=date_create($date1);
        $date2=date_create($date2); 
        $dateDiff = date_diff($date1, $date2);
        $diff = $dateDiff->format("%a"); // in days
        return $diff;
    }

    function getDateSpecificMessage($differenceWithSign, $differenceWithoutSign){
        $diffMessage = '';
        if($differenceWithSign == '+1'){
            $diffMessage = 'tommorrow';
        }else if($differenceWithSign == '-1'){
            $diffMessage = 'yesterday';
        }else if($differenceWithSign == '+0'){
            $diffMessage = 'today';
        }else if($differenceWithSign > '+1'){
            $diffMessage = 'in '. $differenceWithoutSign .' days';
        }elseif($differenceWithSign < '-1'){
            $differenceWithSign = $differenceWithoutSign .' days before';
        }
        return $diffMessage;
    }

//-----------------------------------------------------------------------

    function getFirstLetterOfString($string)
    {
    	return substr($string, 0, 1);
    }

    function getPrefixForItemCode($string)
    {
    	$stringsArr = ['Ring'=>'R', 'Necklace'=>'N', 'Bracelet'=>'BR', 'Bracelate'=>'BR', 'Pendent'=>'P', 'Brooch'=>'BO', 'Earing'=>'E', 'Others'=>'O', 'Jewelleries' =>'I', 'Job'=>'J', 'Quotation'=>'Q', 'Voucher'=>'VN', 'Invoice'=>'IN', 'Consignment'=>'C' ];

    	return (array_key_exists($string, $stringsArr)) ? $stringsArr[$string] : getFirstLetterOfString($string);
    }

    function getItemCode($zeroes, $running_no, $string=null)
    {
    	// $zeros = 5;
        // 	$string = null;
    	if($string === null || $string == ''){
    		$code = sprintf("%0".$zeroes."d", $running_no);
    	}else{
    		$prefix = getPrefixForItemCode($string);
    		$code = $prefix . sprintf("%0".$zeroes."d", $running_no);
    	}
    	return $code;
    }
    
//-----------------------------------------------------------------------

    // Get Quotation Item Image
    function quotationItemImage($quotationItem)
    {
        $imageUrl = null;
        if($quotationItem->jewellery_id){
            if(!empty($quotationItem->jewellery) && $quotationItem->jewellery->drawing_image){
                $imageUrl = $quotationItem->jewellery->drawing_image_url;
            }else if(!empty($quotationItem->jewellery) && count($quotationItem->jewellery->images)){
                $imageUrl = $quotationItem->jewellery->images[0]->image_url;
            } 
        }else {
            if($quotationItem->drawing_image){
                $imageUrl = $quotationItem->drawing_image_url;
            }else if(count($quotationItem->quotation_item_image)){
                $imageUrl = $quotationItem->quotation_item_image[0]->image_url;
            }
        }
        return $imageUrl;
    }

//-----------------------------------------------------------------------

    // Get Invoice Item Image
    function invoiceItemImage($invoiceItem)
    {
        $imageUrl = null;
        if($invoiceItem->jewellery_id){
            // dd(@$invoiceItem->jewellery);
            if(!empty($invoiceItem->jewellery) && $invoiceItem->jewellery->drawing_image){
                $imageUrl = $invoiceItem->jewellery->drawing_image_url;
            }else if(!empty($invoiceItem->jewellery) && count($invoiceItem->jewellery->images)){
                $imageUrl = $invoiceItem->jewellery->images[0]->image_url;
            } 
        }else if($invoiceItem->quotation_item){
            if(!empty($invoiceItem->quotation_item) && $invoiceItem->quotation_item->drawing_image){
                $imageUrl = $invoiceItem->quotation_item->drawing_image_url;
            }else if(!empty($invoiceItem->quotation_item) && count($invoiceItem->quotation_item->quotation_item_image)){
                $imageUrl = $invoiceItem->quotation_item->quotation_item_image[0]->image_url;
            }
        }
        return $imageUrl;
    }


//-----------------------------------------------------------------------

    function getDetailsFromDbUsingCode($request)
    { 
        $jobs = DB::table('jobs')->selectRaw('id as value, item_code as lable, "J" as table_prefix')->whereNotNull('item_code')->whereDate('created_at', '=', date('Y-m-d'))->having('lable', 'like', $request->q.'%');
        $quotations = DB::table('quotations')->selectRaw('id as value, quotation_no as lable, "Q" as table_prefix')->whereNotNull('quotation_no')->whereDate('created_at', '=', date('Y-m-d'))->having('lable', 'like', $request->q.'%');
        $quotationItems = DB::table('quotation_items')->selectRaw('id as value, item_code as lable, "Q" as table_prefix')->whereNotNull('item_code')->whereDate('created_at', '=', date('Y-m-d'))->having('lable', 'like', $request->q.'%');
        $invoices = DB::table('invoices')->selectRaw('id  as value, invoice_no as lable, "IN" as table_prefix')->whereNotNull('invoice_no')->whereDate('created_at', '=', date('Y-m-d'))->having('lable', 'like', $request->q.'%');
        $invoiceItems = DB::table('invoice_items')->selectRaw('id as value, item_code as lable, "IN" as table_prefix')->whereNotNull('item_code')->whereDate('created_at', '=', date('Y-m-d'))->having('lable', 'like', $request->q.'%');

        $records = DB::table('jobs')->selectRaw('id as value, item_code as lable, "J" as table_prefix')->whereNotNull('item_code')->whereDate('created_at', '=', date('Y-m-d'))->having('lable', 'like', $request->q.'%')->union($quotations)->union($quotationItems)->union($invoices)->union($invoiceItems)->get()->take(25);

        return $records->toArray();
    }


//-----------------------------------------------------------------------   
    function getTotalJobsCount()
    {
    	return Job::total()->count();
    }

    function getCompletedJobsCount()
    {
    	return Job::completed()->count();
    }

    function getTotalQuotationsCount()
    {
    	return Quotation::total()->count();
    }

    function getTotalInvoicesCount()
    {
    	return Invoice::total()->count();
    }

    function getConvertedInvoicesCount()
    {
    	return Invoice::convertedInvoices()->count();
    }


//-----------------------------------------------------------------------
    function getMonthlyTotalJobsCount()
    {
    	return Job::total()->monthly()->count();
    }

    function getMonthlyBespokeJobsCount()
    {
    	return Job::bespoke()->monthly()->count();
    }

    function getMonthlyRepairJobsCount()
    {
    	return Job::repair()->monthly()->count();
    }

    function getMonthlyNotAssignedJobsCount()
    {
    	return Job::notAssigned()->monthly()->count();
    }

    function getMonthlyNotStartedJobsCount()
    {
    	return Job::notStarted()->monthly()->count();
    }

    function getMonthlyCraftingJobsCount()
    {
    	return Job::crafting()->monthly()->count();
    }

    function getMonthlyCompletedJobsCount()
    {
    	return Job::completed()->monthly()->count();
    }

    function getMonthlyReceivedJobsCount()
    {
    	return Job::received()->monthly()->count();
    }

    function getMonthlyDelayedJobsCount()
    {
    	return Job::delayed()->monthly()->count();
    }

    function getMonthlyTotalJobsList()
    {
    	return Job::total()->monthly()->get();
    }
//------------------------------------------------------------------------

    function calculatePercentage($input, $total)
    {
    	if(($total == 0) && ($input > 0)){
    		return 100;
    	}else if(($input == 0) && ($total > 0)){
    		return 0;
    	}else if($total){
    		$percentage = ($input * 100) / $total;
    		return round($percentage, 2);
    	}else{
    		return $total;
    	}
    }


    function calculatePreviousDate($days)
    {
    	return date('Y-m-d', strtotime(' - '.$days.' days'));
    }

    function calculateJobReportVariation($dynamicScope){
    	$currentDate = date('Y-m-d');
    	$dateBeforeThiryDays = calculatePreviousDate(30);
    	$dateBeforeThiryOneDays = calculatePreviousDate(31);
    	$dateBeforeSixtyDays = calculatePreviousDate(60);

    	$firstCount = Job::specificJobsCountInRange($dynamicScope, $currentDate, $dateBeforeThiryDays);
    	$secondCount = Job::specificJobsCountInRange($dynamicScope, $dateBeforeThiryOneDays, $dateBeforeSixtyDays);

    	$firstPercentage = calculatePercentage($firstCount, $secondCount);
    	$secondPercentage = calculatePercentage($secondCount, $secondCount); 

    	$percentageDiff = $firstPercentage - $secondPercentage;

    	return $percentageDiff; 
    }

    function calculateJobReportVariationYearly($dynamicScope){
    	$currentDate = date('Y-m-d');
    	$dateBefore365Days = calculatePreviousDate(365);
    	$dateBefore366Days = calculatePreviousDate(366);
    	$dateBefore730Days = calculatePreviousDate(730);

    	$firstCount = Job::specificJobsCountInRange($dynamicScope, $currentDate, $dateBefore365Days);
    	$secondCount = Job::specificJobsCountInRange($dynamicScope, $dateBefore366Days, $dateBefore730Days);

    	$firstPercentage = calculatePercentage($firstCount, $secondCount);
    	$secondPercentage = calculatePercentage($secondCount, $secondCount); 

    	$percentageDiff = $firstPercentage - $secondPercentage;

    	return $percentageDiff; 
    }

    function calculateQuotationReportVariationYearly($dynamicScope){
    	$currentDate = date('Y-m-d');
    	$dateBefore365Days = calculatePreviousDate(365);
    	$dateBefore366Days = calculatePreviousDate(366);
    	$dateBefore730Days = calculatePreviousDate(730);

    	$firstCount = Quotation::specificQuotationsCountInRange($dynamicScope, $currentDate, $dateBefore365Days);
    	$secondCount = Quotation::specificQuotationsCountInRange($dynamicScope, $dateBefore366Days, $dateBefore730Days);

    	$firstPercentage = calculatePercentage($firstCount, $secondCount);
    	$secondPercentage = calculatePercentage($secondCount, $secondCount); 

    	$percentageDiff = $firstPercentage - $secondPercentage;

    	return $percentageDiff; 
    }

    function calculateInvoiceReportVariationYearly($dynamicScope){
    	$currentDate = date('Y-m-d');
    	$dateBefore365Days = calculatePreviousDate(365);
    	$dateBefore366Days = calculatePreviousDate(366);
    	$dateBefore730Days = calculatePreviousDate(730);

    	$firstCount = Invoice::specificInvoicesCountInRange($dynamicScope, $currentDate, $dateBefore365Days);
    	$secondCount = Invoice::specificInvoicesCountInRange($dynamicScope, $dateBefore366Days, $dateBefore730Days);

    	$firstPercentage = calculatePercentage($firstCount, $secondCount);
    	$secondPercentage = calculatePercentage($secondCount, $secondCount); 

    	$percentageDiff = $firstPercentage - $secondPercentage;

    	return $percentageDiff;
    }

//-----------------------------------------------------------------------

    function numberCode($number)
    {
        if ($number == 1) {
            $num = "Y";
        } elseif ($number == 2) {
            $num = "H";
        } elseif ($number == 3) {
            $num = "S";
        } elseif ($number == 4) {
            $num = "K";
        } elseif ($number == 5) {
            $num = "P";
        } elseif ($number == 6) {
            $num = "M";
        } elseif ($number == 7) {
            $num = "W";
        } elseif ($number == 8) {
            $num = "T";
        } elseif ($number == 9) {
            $num = "F";
        } elseif ($number == 0) {
            $num = "Q";
        } else {
            $num = "";
        }
        return $num;
    }

    function changeStringByCode($markupInt)
    {
        $arrayString = str_split($markupInt);
        $numCodeArr = [];
        foreach ($arrayString as $key => $char) {
            if ($key >= 1) {
                $numberCode = numberCode($char);
                $numCodeArr[] = $numberCode;
            }
        }
        return $codeString = implode($numCodeArr);
    }

    function refinedCode($markupValue)
    {
        $markupInt = (int)($markupValue);
        $countDigits = strlen($markupInt);
        $firstnum = "";
        if ($countDigits == 6) {
            $codeString = changeStringByCode($markupInt);
            if ($markupValue[0] != 1) {
              $firstnum = numberCode($markupValue[0]);
            }
            $refinedCode = $codeString . $firstnum . "XXX";
        } elseif ($countDigits == 5) {
            $codeString = changeStringByCode($markupInt);
            if ($markupValue[0] != 1) {
              $firstnum = numberCode($markupValue[0]);
            }
            $refinedCode = $codeString . $firstnum . "XX";
        } elseif ($countDigits == 4) {
            $codeString = changeStringByCode($markupInt);
            if ($markupValue[0] != 1) {
              $firstnum = numberCode($markupValue[0]);
            }
            $refinedCode = $codeString . $firstnum . "X";
        } elseif ($countDigits == 3) {
            $codeString = changeStringByCode($markupInt);
            if ($markupValue[0] != 1) {
              $firstnum = numberCode($markupValue[0]);
            }
            $refinedCode = $codeString . $firstnum . "Z";
        } elseif ($countDigits == 2) {
            $codeString = changeStringByCode($markupInt);
            if ($markupValue[0] != 1) {
             $firstnum = numberCode($markupValue[0]);
            }
            $refinedCode = $codeString . $firstnum . "U";
        } elseif ($countDigits == 1) {
            $codeString = changeStringByCode($markupInt);
            if ($markupValue[0] != 1) {
             $firstnum = numberCode($markupValue[0]);
            }
            $refinedCode = $codeString . $firstnum . "J";
        } else {
            $refinedCode = "";
        }
        return $refinedCode;
    }

    function itemString($data)
    {
        $gold_color_name   =  !empty($data->gold_color) ? $data->gold_color->name : " ";
        $category_name     =  !empty($data->category) ? $data->category->name : " ";
        $item_string       =  "18k " .$gold_color_name . " ". $category_name . "(Small) Link chain";
        if($item_string){
           $string =   $item_string;
        }else{
            $string = " ";
        }
        return $string;
    }

    function deleteItemsInJewellery($modelsItems){
        $res= [];
        $collection = collect($modelsItems);

        $jewellery_ids =  $collection->map(function($item){
           return  $item->jewellery_id;
        });
        $delete_jewellery = Jewellery::whereIn("id", $jewellery_ids)->delete();
        if($delete_jewellery){
            $res['status'] = 1;
            $res['message'] = 'Jewellery deleted successfully!';
        } else{
            $res['status'] = 0;
            $res['message'] = 'Jewellery not deleted!';
        }  
        return   $res; 
    } 


?>
