<?php

namespace App\Exports\Jobs;

use App\Models\Job;
use Maatwebsite\Excel\Excel;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use PhpOffice\PhpSpreadsheet\Shared\Date;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use Maatwebsite\Excel\Concerns\WithMapping;

//Drawing
// use Maatwebsite\Excel\Concerns\WithDrawings;
// use PhpOffice\PhpSpreadsheet\Worksheet\Drawing;
use Maatwebsite\Excel\Concerns\WithCustomStartCell;

//Styling
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithColumnWidths;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Style;
use PhpOffice\PhpSpreadsheet\Style\Color;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
// use Maatwebsite\Excel\Concerns\WithBackgroundColor;

class CompletedJobsExport implements FromCollection, WithHeadings, WithColumnFormatting, WithMapping, ShouldAutoSize, WithColumnWidths, WithStyles //, WithBackgroundColor
{

    public function __construct($start_date, $end_date)
    {
        $this->start_date = $start_date;
        $this->end_date = $end_date;
    }

    public function headings(): array 
    {
        return [ 'Item Code', 'Est. Completion', 'Earing Pin', 'Gold Weight', 'Gold Cost', 'Craftmanship Cost', 'Polishing', 'Job Status', 'Date', 'Description', 'Size', 'Is Sample Provided', 'Sample Description', 'Setting Cost', 'Backing Cost', 'Backing Type', 'Backing Size', 'Backing Quantity', 'Claw' ];
    }

    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        return Job::select('item_code', 'estimate_completion', 'earing_pin', 'gold_weight', 'gold_cost', 'craftsmanship_cost', 'polishing',  'job_status', 'date', 'description', 'size', 'is_sample_provided', 'sample_description', 'setting_cost', 'backing_cost', 'backing_type', 'backing_size', 'backing_quantity', 'claw')->completed()->whereBetween('created_at', [$this->start_date, $this->end_date])->get();
    }

    public function map($job): array
    {
        return [
            $job->item_code,
            // Date::dateTimeToExcel($job->estimate_completion),
            $job->estimate_completion,
            $job->earing_pin ?? '-',
            $job->gold_weight ?? '-',
            $job->gold_cost ?? '-',
            $job->craftsmanship_cost ?? '-',
            $job->polishing ?? '-',
            $job->job_status,
            Date::dateTimeToExcel($job->date),
            // $job->date,
            $job->description ?? '-',
            $job->size ?? '-',
            $job->is_sample_provided ?? '-',
            $job->sample_description ?? '-',
            $job->setting_cost ?? '-',
            $job->backing_cost ?? '-',
            $job->backing_type ?? '-',
            $job->backing_size ?? '-',
            $job->backing_quantity ?? '-',
            $job->claw ?? '-',
        ];
    }

    public function columnFormats(): array
    {
        return [
            'A' => NumberFormat::FORMAT_TEXT, //TEXT
            // 'B' => NumberFormat::FORMAT_DATE_DDMMYYYY,
            // 'B' => NumberFormat::FORMAT_DATE_DMYSLASH,
            'B' => NumberFormat::FORMAT_TEXT ,
            'C' => NumberFormat::FORMAT_NUMBER_00, // DECIMAL DIGIT
            'D' => NumberFormat::FORMAT_NUMBER_00,
            // 'E' => NumberFormat::FORMAT_CURRENCY_USD_SIMPLE,
            'E' => NumberFormat::FORMAT_CURRENCY_USD, // CURRENCY
            'F' => NumberFormat::FORMAT_CURRENCY_USD,
            'G' => NumberFormat::FORMAT_CURRENCY_USD,
            'H' => NumberFormat::FORMAT_TEXT,
            'I' => NumberFormat::FORMAT_DATE_DDMMYYYY, // DATE
            'J' => NumberFormat::FORMAT_TEXT, // DESCRIPTION
            'K' => NumberFormat::FORMAT_TEXT,
            'L' => NumberFormat::FORMAT_TEXT,
            'M' => NumberFormat::FORMAT_TEXT, // DESCRIPTION
            'N' => NumberFormat::FORMAT_CURRENCY_USD,
            'O' => NumberFormat::FORMAT_CURRENCY_USD ,
            'P' => NumberFormat::FORMAT_TEXT,
            'Q' => NumberFormat::FORMAT_NUMBER_00,
            'R' => NumberFormat::FORMAT_NUMBER, // INTEGER
            'S' => NumberFormat::FORMAT_TEXT 
        ];
    }

    // // Drawing
    // public function drawings()
    // //: array
    // {
    //     // //wORKING fINE
    //     // $drawing = new Drawing();
    //     // $drawing->setName('Sample Drawing');
    //     // $drawing->setDescription('Sample Drawing provided by customer');
    //     // $drawing->setPath(public_path('img/default-placeholder.jpg'));
    //     // $drawing->setHeight(60);
    //     // $drawing->setCoordinates('F1');
    //     // return $drawing;

    //     //---------------------------------------------------

    //     $rowNum = 2;
    //     $drawings = [];

    //     $jobs = $this->query();
    //     foreach ($jobs as $row) {
    //         if($row)
    //         {
    //             $drawing = new Drawing();
    //             $drawing->setName('image');
    //             $drawing->setDescription('image');
    //             // $drawing->setPath(public_path('08/'.$drawing_temp->cod_producto.'.jpg'));

    //             // $drawing->setPath($row->drawing_image_url);
    //             $drawing->setPath(public_path('img/drawing_images/'.$job->drawing_image));
    //             // $drawing->setCoordinates('F'.$rowNum);
    //             $drawing->setPath(public_path('img/default-placeholder.jpg'));

    //             $drawing->setHeight(50);
    //             // $drawing->setOffsetX(100);
    //             // $drawing->setOffsetY(100);
    //             $drawing->setCoordinates('F'.$rowNum);
    //             $drawings[] = $drawing;
    //         }
    //         $rowNum++;
    //     }
    //     return $drawings;
    // }

    public function startCell(): string
    {
        return 'A4';
    }

    // public function registerEvents():array
    // {
    //     return [
    //         AfterSheet::class => function (AfterSheet $event) {
    //             $workSheet = $event->sheet->getDelegate();

    //             // insert images
    //             foreach ($this->getDrawings() as $drawing) {
    //                 $drawing->setWorksheet($workSheet);
    //             }
    //         },
    //     ];
    // }



    //Styling
    public function columnWidths(): array
    {
        // Only the columns with explicit widths won't be autosized.
        // 100 is almost 1/2 of the fullscreen
        return [
            'A' => 15,
            'B' => 20,
            'C' => 17,
            'J' => 40, // DESCRIPTION
            'M' => 40, // SAMPLE DESCRIPTION 
        ];
    }

    public function styles(Worksheet $sheet)
    {
        return [
            // Style the first row as bold text.
            1    => ['font' => ['bold' => true], 'alignment' => ['horizontal' => Alignment::HORIZONTAL_LEFT]],
            'E' => ['font' => ['bold' => true]], // CURRENCY
            'F' => ['font' => ['bold' => true]], //'size' => 14
            'G' => ['font' => ['bold' => true]],

            'J' => ['alignment' => ['wrapText' => true]], // DESCRIPTION
            'M' => ['alignment' => ['wrapText' => true]], // SAMPLE DESCRIPTION  

            'N' => ['font' => ['bold' => true]], // CURRENCY
            'O' => ['font' => ['bold' => true]],

            // // Styling a specific cell by coordinate.
            // 'B2' => ['font' => ['italic' => true]],

            // // Styling an entire column.
            // 'C'  => ['font' => ['size' => 16]],
        ];
    }

    // public function backgroundColor()
    // {
    //     // Return RGB color code.
    //     return '000000'; // 87CEEB For whole sheet
    // }



} 