<?php

namespace App\Exports\Invoices;

use App\Models\Invoice;
use Maatwebsite\Excel\Excel;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use PhpOffice\PhpSpreadsheet\Shared\Date;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use Maatwebsite\Excel\Concerns\WithMapping;

//Drawing
// use Maatwebsite\Excel\Concerns\WithDrawings;
// use PhpOffice\PhpSpreadsheet\Worksheet\Drawing;
use Maatwebsite\Excel\Concerns\WithCustomStartCell;

//Styling
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithColumnWidths;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Style;
use PhpOffice\PhpSpreadsheet\Style\Color;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
// use Maatwebsite\Excel\Concerns\WithBackgroundColor;

class TotalInvoicesExport implements FromCollection, WithHeadings, WithColumnFormatting, WithMapping, ShouldAutoSize, WithColumnWidths, WithStyles //, WithBackgroundColor
{

    public function __construct($start_date, $end_date)
    {
        $this->start_date = $start_date;
        $this->end_date = $end_date;
    }

    public function headings(): array 
    {
        return [ 'Invoice Number', 'Quotation Id', 'Staff Name', 'Staff Id', 'Customer Name', 'Customer Id', 'SubTotal', 'GST Percent', 'GST Amount', 'Total', 'Layaway', 'Reference Date' ];
    }

    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        return Invoice::select('invoice_no', 'quotation_id', 'staff_name', 'staff_id', 'customer_name', 'customer_id', 'sub_total', 'gst_percent',  'gst_amount', 'total', 'layaway', 'reference_date')->whereBetween('created_at', [$this->start_date, $this->end_date])->get();
    }

    public function map($invoice): array
    {
        return [
            $invoice->invoice_no,
            $invoice->quotation_id,
            $invoice->staff_name ?? '-',
            $invoice->staff_id ?? '-',
            $invoice->customer_name ?? '-',
            $invoice->customer_id ?? '-',
            $invoice->sub_total ?? '-',
            $invoice->gst_percent ?? '-',
            $invoice->gst_amount,
            $invoice->total ?? '-',
            $invoice->layaway ?? '-',
            !empty($invoice->referencedate) ? Date::dateTimeToExcel($invoice->referencedate) : '-',
        ];
    }

    public function columnFormats(): array
    {
        return [
            'A' => NumberFormat::FORMAT_TEXT, //TEXT
            'B' => NumberFormat::FORMAT_NUMBER ,
            'C' => NumberFormat::FORMAT_TEXT ,
            'D' => NumberFormat::FORMAT_NUMBER , // DECIMAL DIGIT
            'E' => NumberFormat::FORMAT_TEXT,
            'F' => NumberFormat::FORMAT_NUMBER , // CURRENCY
            'G' => NumberFormat::FORMAT_CURRENCY_USD,
            'H' => NumberFormat::FORMAT_NUMBER_00,
            'I' => NumberFormat::FORMAT_CURRENCY_USD,
            'J' => NumberFormat::FORMAT_CURRENCY_USD, // DATE
            'K' => NumberFormat::FORMAT_TEXT, // DESCRIPTION
            'L' => NumberFormat::FORMAT_DATE_DDMMYYYY,   
        ];
    }

    // // Drawing
    // public function drawings()
    // //: array
    // {
    //     // //wORKING fINE
    //     // $drawing = new Drawing();
    //     // $drawing->setName('Sample Drawing');
    //     // $drawing->setDescription('Sample Drawing provided by customer');
    //     // $drawing->setPath(public_path('img/default-placeholder.jpg'));
    //     // $drawing->setHeight(60);
    //     // $drawing->setCoordinates('F1');
    //     // return $drawing;

    //     //---------------------------------------------------

    //     $rowNum = 2;
    //     $drawings = [];

    //     $jobs = $this->query();
    //     foreach ($jobs as $row) {
    //         if($row)
    //         {
    //             $drawing = new Drawing();
    //             $drawing->setName('image');
    //             $drawing->setDescription('image');
    //             // $drawing->setPath(public_path('08/'.$drawing_temp->cod_producto.'.jpg'));

    //             // $drawing->setPath($row->drawing_image_url);
    //             $drawing->setPath(public_path('img/drawing_images/'.$job->drawing_image));
    //             // $drawing->setCoordinates('F'.$rowNum);
    //             $drawing->setPath(public_path('img/default-placeholder.jpg'));

    //             $drawing->setHeight(50);
    //             // $drawing->setOffsetX(100);
    //             // $drawing->setOffsetY(100);
    //             $drawing->setCoordinates('F'.$rowNum);
    //             $drawings[] = $drawing;
    //         }
    //         $rowNum++;
    //     }
    //     return $drawings;
    // }

    public function startCell(): string
    {
        return 'A4';
    }

    // public function registerEvents():array
    // {
    //     return [
    //         AfterSheet::class => function (AfterSheet $event) {
    //             $workSheet = $event->sheet->getDelegate();

    //             // insert images
    //             foreach ($this->getDrawings() as $drawing) {
    //                 $drawing->setWorksheet($workSheet);
    //             }
    //         },
    //     ];
    // }



    //Styling
    public function columnWidths(): array
    {
        // Only the columns with explicit widths won't be autosized.
        // 100 is almost 1/2 of the fullscreen
        return [
            'A' => 15,
            'B' => 20,
            'C' => 17,
            'J' => 40, // DESCRIPTION
            'M' => 40, // SAMPLE DESCRIPTION 
        ];
    }

    public function styles(Worksheet $sheet)
    {
        return [
            // Style the first row as bold text.
            1    => ['font' => ['bold' => true], 'alignment' => ['horizontal' => Alignment::HORIZONTAL_LEFT]],
            'E' => ['font' => ['bold' => true]], // CURRENCY
            'F' => ['font' => ['bold' => true]], //'size' => 14
            'G' => ['font' => ['bold' => true]],

            'J' => ['alignment' => ['wrapText' => true]], // DESCRIPTION
            'M' => ['alignment' => ['wrapText' => true]], // SAMPLE DESCRIPTION  

            'N' => ['font' => ['bold' => true]], // CURRENCY
            'O' => ['font' => ['bold' => true]],

            // // Styling a specific cell by coordinate.
            // 'B2' => ['font' => ['italic' => true]],

            // // Styling an entire column.
            // 'C'  => ['font' => ['size' => 16]],
        ];
    }

    // public function backgroundColor()
    // {
    //     // Return RGB color code.
    //     return '000000'; // 87CEEB For whole sheet
    // }



} 