<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [ // added by ss
        Commands\JobDeadlineAlertCron::class,
        Commands\JobOverDueAlertCron::class,
        Commands\ArchiveOldJobOrdersCron::class,
    ];

    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        // $schedule->command('inspire')->hourly(); // by default
        $schedule->command('jobDeadlineAlert:cron')->hourly()->emailOutputOnFailure(env('MAIL_FROM_ADDRESS'));  // daily //everyMinute // added by ss 

        $schedule->command('jobOverDueAlert:cron')->hourly()->emailOutputOnFailure(env('MAIL_FROM_ADDRESS')); // added by ss  // everyTenMinutes

        $schedule->command('archiveOldJobOrders:cron')->daily()->emailOutputOnFailure(env('MAIL_FROM_ADDRESS')); // added by ss 
    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
