<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Notifications\JobOverDueAlertNotification;
use App\Models\Job;
use Notification;
use Log;

class JobOverDueAlertCron extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'jobOverDueAlert:cron';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        try{
            Log::debug("Job Over Due Alert Cron is working fine!");

            $currentDate = date('Y-m-d');

            // Alert 
            $dueJobs = Job::with(['staff:id,fullname,email,image'])->where('estimate_completion',  '>', $currentDate)->get([ 'id', 'item_code', 'staff_id', 'estimate_completion' ]);
           
            foreach($dueJobs as $key=>$value){
                $notifications = \DB::table('notifications')->count();

                $notificationId = ($notifications ?? 0) + 1;
                $notificationType = 'Job Over Due Alert';
                
                $newEstimateCompletion = date("Y-m-d H:i:s", strtotime($value->estimate_completion.' 00:00:00'));
                
                $diffFormat = dateDifferenceInDaysWithSign(date("Y-m-d 00:00:00"), $newEstimateCompletion);
                $diff = dateDifferenceInDaysWithoutSign(date("Y-m-d 00:00:00"), $newEstimateCompletion);
                $diffMessage = getDateSpecificMessage($diffFormat, $diff);

                $notificationMessage = [];
                $notificationMessage['message'] = 'is due '.$diffMessage;
                $notificationMessage['item_code'] = $value->item_code ?? 'Job Id:'.$value->id;
                $notificationMessage['date_time'] = date("d F Y, H:iA", strtotime($value->estimate_completion));
                
                $body = $notificationMessage['item_code']. " ".$notificationMessage['message'].". i.e. ".$notificationMessage['date_time'];
                
                $userFullName = $value->staff ? ($value->staff->fullname ?? '') : '';

                // Notification
                $details = [
                    'greeting'        => 'Hi '.$userFullName, 
                    'body'            => $body,
                    'thanks'          => 'Thank you',
                    'data'            => $notificationMessage,
                ];
                $value->staff->notify(new JobOverDueAlertNotification($details));
            }
        }catch(\Exception $err){
            Log::error('message error in handle on JobOverDueAlertCron :'. $err->getMessage());
        }
    }
}
