<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Notifications\JobDeadlineAlertNotification;
use App\Models\Job;
// use App\Models\Notification;
use Notification;
use Log;

class JobDeadlineAlertCron extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'jobDeadlineAlert:cron';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        try{
            Log::debug("Job Deadline Alert Cron is working fine!");

            $newDate = [];
            $beforeJobs = [];
            $currentDate = date('Y-m-d');

            $daysArr = ['oneWeek'=>5, 'threeDays'=>3, 'oneDay'=>1];

            $messageArr = [
                'oneWeek'   => 'is due next week.', 
                'threeDays' => 'is due in 3 days.', 
                'oneDay'    => 'is due tomorrow.',
            ];

            foreach ($daysArr as $key => $value) {
                $newDate[$key] = date('Y-m-d', strtotime(' + '.$value.' days'));

                $beforeJobs[$key] = Job::with(['staff:id,fullname,email,image'])->where('estimate_completion',  $newDate[$key])->get([ 'id', 'item_code', 'staff_id', 'estimate_completion' ]);
                
                foreach($beforeJobs[$key] as $k=>$v){
                    $notifications = \DB::table('notifications')->count();

                    $notificationId = ($notifications ?? 0) + 1;
                    $notificationType = 'Job Deadline Alert';

                    $notificationMessage['message'] = $messageArr[$key];
                    $notificationMessage['item_code'] = $v->item_code ?? 'Job Id:'.$v->id;
                    $notificationMessage['date_time'] = date("d F Y, H:iA", strtotime($v->estimate_completion));
                    
                    $body = $notificationMessage['item_code']. " ".$notificationMessage['message']." i.e. ".$notificationMessage['date_time'];
                    
                    $userFullName = $v->staff ? ($v->staff->fullname ?? '') : '';

                    // Notification
                    $details = [
                        'greeting'        => 'Hi '.$userFullName, 
                        'body'            => $body,
                        'thanks'          => 'Thank you',
                        'data'            => $notificationMessage,
                    ];
                
                    //Send Notification to single user
                    $v->staff->notify(new JobDeadlineAlertNotification($details));
                }
            }
        }catch(\Exception $err){
            Log::error('message error in handle on JobDeadlineAlertCron :'. $err->getMessage());
        }
    }
}
