<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Notifications\JobOverDueAlertNotification;
use App\Models\Job;
use Notification;
use Log;

class ArchiveOldJobOrdersCron  extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'archiveOldJobOrders:cron';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        try{
            Log::debug("Archive Old Job Orders Cron is working fine!");

            $currentDate = date('Y-m-d h:i:s');
            $years = 1;
            $previousDate = date('Y-m-d h:i:s', strtotime(' - '.$years.' years'));

            $jobsToArchive = Job::where('created_at', '<', $previousDate)->get(['id', 'item_code']);

            // Multiple soft delete
            $archiveJobs = Job::whereIn('id', $jobsToArchive->pluck('id'))->delete();
            if($archiveJobs){
                Log::info("Archive Old Job Orders done!");
            }else{
                Log::error("Archive Old Job Orders not done!");
            }
        }catch(\Exception $err){
            Log::error('message error in handle on ArchiveOldJobOrdersCron  :'. $err->getMessage());
        }
    }
}
